/** Common GUI functions. **/

window.DEBUG_MODE = true;

/**
 * URL hash dispatcher.
 */
function windowParseUrl() {
	window.parsed = true;
	var registerInterval = 0;

	var hash = window.location.hash;
	console.log('windowParseUrl ' + hash + ' ' + ((new Date().getTime()) / 1000));

	if (hash == window.storeForMeOldHash)
		return;
	window.storeForMeOldHash = hash;

	$.get(window.links.studentAjaxIsLoggedIn, function(result) {
		if (hash == '#city' && result == 1) {
			showMinimap();
		} else
			$("#minimap-linkback").css("display", "none");
		$(".tipsy-w").css("display", "none");
		$("#symbol-hidemap-img").removeClass("showmap");
		$("#symbol-hidemap-img").addClass("hidemap");

	});
	//hide right sidebar
	$('#sidebar-hide').click();

	//close dialogs
	$('.ui-dialog > .ui-dialog-content').each(function() {
		if ($(this).dialog('isOpen'))
			$(this).dialog('close');
	});

	//remove tooltips
	$('.interiorTooltip').remove();

	switch (hash) {
		case "#register":
			$.get(window.links.studentAjaxIsLoggedIn, function(result) {
				// this form only works when not logged in and if registration is enabled
				if (result != 1) {
					window.isLoggedIn = false;

					$.get(window.links.studentAjaxIsRegistrationEnabled, function(regEnabled) {
						if (regEnabled == 1) {
							function showRegister() {
								resetIntroStyle();
								$(".ui-dialog-content").dialog("close");
								$("#dialog-register").dialog("open");
							}

							if ($("#dialog-register").find("register-form").length <= 0) // check if form not loaded
							{
								$("#dialog-register").load(window.links.studentAjaxRegister, function() {
									activateRegister();
									showRegister();
								});
							} else if ($("#dialog-register").dialog("isOpen") == false) {
								showRegister();
							}
						} else window.location.hash = "";
					});
				} else window.location.hash = "";
			});
			break;

		case "#password":
			$.get(window.links.studentAjaxIsLoggedIn, function(result) {
				if (result != 1) // this form only works when not logged in
				{
					window.isLoggedIn = false;

					function showPassword() {
						resetIntroStyle();
						$(".ui-dialog-content").dialog("close");
						$("#dialog-password").dialog("open");
					}

					if ($("#dialog-password").find("password-form").length <= 0) // check if form not loaded
					{
						$("#dialog-password").load(window.links.studentAjaxPassword, function() {
							activatePassword();
							showPassword();
						});
					} else if ($("#dialog-password").dialog("isOpen") == false) // if loaded but not opened
					{
						showPassword();
					}
				} else window.location.hash = "#city";
			});
			break;

		default:
			$.get(window.links.studentAjaxIsLoggedIn, function(result) {
				if (result != 1) {
					window.isLoggedIn = false;

					function showLogin() {
						resetIntroStyle();
						$(".ui-dialog-content").dialog("close");
						$("#dialog-login").dialog("open");
					}

					if ($("#dialog-login").find("login-form").length <= 0) // check if form not loaded
					{
						$("#dialog-login").load(window.links.studentAjaxLogin, function() {
							activateLogin();
							showLogin();
							registerInterval = window.setInterval(updateRegister, 20000);
						});
					} else if ($("#dialog-login").dialog("isOpen") == false) // if loaded but not opened
					{
						showLogin();
					}
				} else {
					$.get(window.links.studentAjaxGetUserData, function(result) {
						//console.log('window.links.studentAjaxGetUserData ' + result);
						if (result != 0 && result != null) {
							var res = jQuery.parseJSON(result);

							Mailbox.update(res['naglowki_wiadomosci']);

							//trigger turaStatusChanged event handlers
							if (window.userdata == null || parseInt(window.userdata['tura_aktywna']) != parseInt(res['tura_aktywna'])) {
								$(window).trigger('turaStatusChanged', parseInt(res['tura_aktywna']));
							}

							window.userdata = res;
							window.isLoggedIn = true;

							//check if current interior is allowed
							var currentInterior = window.location.hash.substring(1);
							if (currentInterior.length > 0 && !isInteriorAllowed(currentInterior))
								window.location.hash = '#city';

							/// === DEBUG ONLY ===============================================
							if (window.DEBUG_MODE && userdata != null && parseInt(userdata.tura) == -1)
								window.game.debugEnableAllBuildings();
							else
								window.game.enableAllowedBuildings();
							/// === BUT THIS IS ACTUALLY USEFUL ==============================

							/*
														$("#bottombar").animate({right: "0px", bottom: "0px"}, 2000, "easeOutExpo");
														var sidebarPosition = $('#mainCanvas').height()/3-$("#sidebar").height()/2;
														$("#sidebar").animate({right:"0px",top:sidebarPosition}, 2000, "easeInExpo");
							                                        		$("#minimap").fadeIn(2000);
							*/
							updateTime();
							updateLesson();
							clearInterval(registerInterval);
							clearInterval(window.updateGameDataInterval);
							window.updateGameDataInterval = window.setInterval(updateGameData, 30000);
							window.kontrahentdata = jQuery.parseJSON(window.userdata["kontrahenci"]);
							window.buildingdata = jQuery.parseJSON(window.userdata["budynki"]);
							window.biurodata = jQuery.parseJSON(window.userdata["biura"]);
							window.bankdata = jQuery.parseJSON(window.userdata["banki"]);
							window.game.enableAllowedBuildings();

							$("#footer").hide("slide", {
								direction: "down"
							}, 1000, function() {
								if (!$("#symbol-komputer").is(":visible")) {
									$("#button-back").hide();
									$("#rightbuttons").show();

									$("#bottombar").animate({
										right: "0px",
										bottom: "0px"
									}, 2000, "easeOutExpo");
									var sidebarPosition = $('#mainCanvas').height() / 3 - $("#sidebar").height() / 2;
									$("#sidebar").animate({
										right: "0px",
										top: sidebarPosition
									}, 2000, "easeInExpo");
									$("#minimap").fadeIn(2000);

									$("#button-ue").fadeIn(1000);
									$("#button-about").fadeIn(1000);
									$("#clockbar").animate({
										left: "-20px"
									}, 2000, "easeInExpo");
									$("#lessonbar").animate({
										right: "-20px"
									}, 2000, "easeInExpo");

									if (window.lockWebTickerTs == null)
										window.lockWebTickerTs = 0;
									//var currentTs = new Date().getTime();
									var currentTs = new Date().getTime();
									if (window.lockWebTickerTs + 1000 < currentTs) {
										window.lockWebTickerTs = currentTs
										checkSize();
										setupButtons();
										parseActions();
										setupSidebarData(false);
									}
								}
							});

							$("#mainmenu a").each(function() { // menudiv
								if (this.text == "Panel administratora")
									$(this).parent().hide(1000);
								if (this.text == "Panel nauczyciela")
									$(this).parent().hide(1000);
								if ($(this).parent().attr('class') == "hiddenMenu")
									$(this).parent().css("display", "inline");
							});
							$("#canvasHolder").css("background-image", "none");
						}
					});

					// check on every hashchange
					getAllowedInteriors();
					setupSidebarData(false);
				}
			});
			break;
	}
}

function getAllowedInteriors() {
	$.ajax({
		url: window.links.studentAjaxGetAllowedInteriors,
		global: false,
		type: 'GET',
		success: function(result) {
			var res = jQuery.parseJSON(result);
			if (res && window.userdata) window.userdata['allowedInteriors'] = res['allowedInteriors'];
			window.game.enableAllowedBuildings();
		}
	});
}

/**
 * Sprawdza czy zadane wnętrze jest dozwolone.
 * Nie sprawdza czy tura jest aktywna.
 * @param {type} string
 * @returns {boolean}
 */
function isInteriorAllowed(interior) {
	return window.userdata != null && window.userdata.allowedInteriors != null &&
		window.userdata.allowedInteriors[interior] != undefined;
}

/**
 * Sprawdza czy zadane wnętrze jest dozwolone, a tura nieaktywna
 * @param {type} string
 * @returns {boolean}
 */
function isInteriorAllowedAndLessonActive(interior) {
	return window.userdata != null && window.userdata.allowedInteriors != null &&
		window.userdata.allowedInteriors[interior] != undefined &&
		parseInt(window.userdata.tura_aktywna);
}

/**
 * Sprawdza czy zadane wnętrze jest dozwolone, a tura aktywna.
 * @param {type} string
 * @returns {boolean}
 */
function isInteriorAllowedAndLessonInactive(interior) {
	return window.userdata != null && window.userdata.allowedInteriors != null &&
		window.userdata.allowedInteriors[interior] != undefined &&
		!parseInt(window.userdata.tura_aktywna);
}

/**
 * Reset css back to intro style.
 */
function resetIntroStyle() {
	$("#footer").show();

	$("#gameSidebar").hide();
	$("#minimap").hide();

	$(".hiddenMenu").css("display", "none");
}

/**
 * Executed every 30 seconds
 */
function updateGameData() {
	updateTime();
	updateLesson();
	getAllowedInteriors();
	setupSidebarData(false);
}

/**
 * Update displayed time, executed every 30 seconds
 */
function updateTime() {
	/* przerobic na ajax */

	/*
	var time = new Date();
	var h = time.getHours();
	var m = time.getMinutes();
	$("#timestring").text(""+(h<=9?'0'+h:h)+":"+(m<=9?'0'+m:m));
	*/

	//	$.get(window.links.studentAjaxGetTime, function(res) {

	$.ajax({
		url: window.links.studentAjaxGetTime,
		global: false, // do not show cursor loading animation for this ajax request
		type: 'GET',
		success: function(res) {
			var time = new Date();
			time.setTime(res);
			var h = time.getHours();
			var m = time.getMinutes();
			$("#timestring").text("" + (h <= 9 ? '0' + h : h) + ":" + (m <= 9 ? '0' + m : m));
		}
	});
}

/**
 * Check and display lesson number, update lesson state, executed every 30 seconds
 */
function updateLesson() {
	// ajax sprawdzenie nr tury i czy aktywna
	$.ajax({
		url: window.links.studentAjaxGetCurrentLesson,
		global: false, // do not show cursor loading animation for this ajax request
		success: function(result) {
			var res = jQuery.parseJSON(result);
			if (res['tura'] != window.userdata['tura']) {
				if (res['tura_aktywna'] && !window.userdata['tura_aktywna']) {
					// if new lesson was started notify and enable some features
					// alert("rozpoczyna się nowa ("+res['tura']+") lekcja");
					// dodac jeszcze wiadomosc z TEXT_NOWA_LEKCJA
					if ($("#dialog-info").dialog("isOpen") === true) {
						$("#dialog-info").dialog('close');
					}
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						activateInfo(parseInt(res["tura"]));
						var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
						$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
					});
				} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
					// if lesson time has passed, notify and disable some features
					//alert("zakończyła się lekcja nr "+window.userdata['tura']);
					if ($("#dialog-info").dialog("isOpen") === true) {
						$("#dialog-info").dialog('close');
					}
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						if (window.userdata.tura <= 4)
							activateInfo(-1);
						else
							activateInfo(0);

						var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
						$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
					});
				} else if (res['tura_aktywna'] && window.userdata['tura_aktywna']) {
					// if new lesson has started directly after previous one
					// showing welcome screen of next lesson - TEST IT
					if ($("#dialog-info").dialog("isOpen") === true) {
						$("#dialog-info").dialog('close');
					}
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						activateInfo(parseInt(res["tura"]));
						var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
						$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
					});
				}

				// update available actions for this lesson
				getAllowedInteriors();
				/*
				$.ajax({
					url: window.links.studentAjaxGetAllowedInteriors,
					global: false,
					success: function(r2) {
						window.userdata['allowedInteriors'] = r2['allowedInteriors'];
					}
				});
				*/
			} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
				// if lesson time has passed, notify and disable some features
				//alert("zakończyła się lekcja nr "+window.userdata['tura']);
				if ($("#dialog-info").dialog("isOpen") === true) {
					$("#dialog-info").dialog('close');
				}
				$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
					if (window.userdata.tura <= 4)
						activateInfo(-1);
					else
						activateInfo(0);

					var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
					$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
				});
			}

			window.userdata['tura'] = res['tura'];
			window.userdata['tura_aktywna'] = res['tura_aktywna'];
		}
	});

	var sactive = (window.userdata['tura_aktywna'] != "0") ? "(trwa)" : "(zakończona)";
	$("#lessonstring").text("Lekcja: " + window.userdata['tura'] + " " + sactive);
}

/**
 * Show register button if registration was enabled, checked every 30 seconds
 */
function updateRegister() {
	if ($("#dialog-login").dialog("isOpen") == true) {
		$.ajax({
			url: window.links.studentAjaxIsRegistrationEnabled,
			global: false, // do not show cursor loading animation for this ajax request
			success: function(result) {
				if (result != 0 && $("#register-button").length <= 0) {
					$("#UserStudentLoginForm_login").after(' <input id="register-button" tabindex="4" name="ytr" type="button" value="Nowe konto" role="button" aria-disabled="false">');
					$("#register-button").button().click(function() {
						window.location.hash = "#register";
					});
				} else if (result == 0 && $("#register-button").length > 0) {
					$("#register-button").remove();
				}
			}
		});
	}
}

/**
 * Parse actions - what was done, what needs to be done.
 */
function parseActions() {
	// po kazdym zalogowaniu pokazujemy okienko dialogowe z informacją o zadaniach do zrobienia w aktualnej lekcji
	//if(parseInt(window.userdata['tura_aktywna']) == 0)
	if (!(window.userdata['tura_aktywna'])) {
		$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
			if (window.userdata.tura <= 4)
				activateInfo(-1);
			else
				activateInfo(0); // brak lekcji (dom)
		});
	} else {
		/*
		$.ajax({
                	url: window.links.studentAjaxIsBlockedAction,
                	global: false,   // do not show cursor loading animation for this ajax request
                	type: 'GET',
			success: function(result)
			{
				if(result > 0)
				{
					$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
						activateInfo(parseInt(window.userdata["tura"]),163); // odrzuconyFormularz blokujemy gre
					});
				}
				else

			}
		});
		*/

		if (parseInt(window.userdata["tura"]) > 0) // lekcja
		{
			$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() { //on firefox loads double time !!!
				activateInfo(parseInt(window.userdata["tura"]));
			});
		}
	}

	// === pobieramy wiadomosci do dolnego tickera ===
	$.ajax({
		url: window.links.studentAjaxGetStudentActionData,
		global: false, // do not show cursor loading animation for this ajax request
		type: 'GET',
		dataType: 'json',
		success: function(result) {
			var messages = jQuery.parseJSON(result["naglowki_akcji"]);

			if (messages.length == 0)
				$("#webticker").html("<li> Nowi przedsiębiorcy w mieście! </li>");
			else {
				for (var i = 0; i < messages.length; i++)
					$("#webticker").append("<li>" + messages[i] + "</li>");
			}
			$("#webticker").webTicker({
				speed: 40,
				direction: "left",
				moving: true,
				startEmpty: true,
				duplicate: true,
				updatetype: "swap",
				hoverpause: false
			});
		}
	});
}

/**
 * Resizing gui - executed on window resize and on minimap hide/show
 */
function checkSize() {
	// center all dialog windows
	$(".ui-dialog-content:visible").dialog("option", "position", "center");

	var wratio = 4096 / window.innerWidth;
	var hratio = 2160 / window.innerHeight;
	var mwratio = 239 / wratio;
	var mhratio = 127 / hratio;
	$("#minimap-radar").width(mwratio);
	$("#minimap-radar").height(mhratio);

	if ($("#minimap").is(":visible")) {
		if (window.innerWidth < 1216) // przyciski GUI w 2 rzędach // 1162
		{
			if (window.game && window.game.currentInterior != -1) {
				$("#rightbuttons").clearQueue().finish().animate({
					marginRight: "321px"
				}, 500, "easeOutExpo"); //350
				$("#buttons").clearQueue().finish().animate({
					height: "51px",
					width: "790px",
					left: (window.innerWidth / 2 - 395) + "px"
				}, 500, "easeOutExpo"); //790
			} else {
				$("#rightbuttons").clearQueue().finish().animate({
					marginRight: "321px"
				}, 500, "easeOutExpo"); //350
				$("#buttons").clearQueue().finish().animate({
					height: "110px",
					width: "790px",
					left: (window.innerWidth / 2 - 395) + "px"
				}, 500, "easeOutExpo"); //790
			}
		} else {
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "321px"
			}, 500, "easeOutExpo"); //350
			$("#buttons").clearQueue().finish().animate({
				height: "51px",
				width: "100%",
				left: "0px"
			}, 500, "easeOutExpo");
		}
	} else {
		if (window.innerWidth < 945) // przyciski GUI w 2 rzędach // 891
		{
			if (window.game && window.game.currentInterior != -1) {
				$("#rightbuttons").css({
					"margin-right": "51px"
				}); //80
				$("#buttons").clearQueue().finish().animate({
					height: "51px",
					width: "520px",
					left: (window.innerWidth / 2 - 255) + "px"
				}, 500, "easeOutExpo"); //w520
			} else {
				$("#rightbuttons").css({
					"margin-right": "51px"
				}); //80
				$("#buttons").clearQueue().finish().animate({
					height: "110px",
					width: "520px",
					left: (window.innerWidth / 2 - 255) + "px"
				}, 500, "easeOutExpo"); //w520 h220
			}
		} else {
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "51px"
			}, 500, "easeOutExpo"); //80
			$("#buttons").clearQueue().finish().animate({
				height: "51px",
				width: "100%",
				left: "0px"
			}, 500, "easeOutExpo");
		}
	}
}

/**
 * Check missed forms
 */
function checkMissedForms() {
	if (!$(".ui-dialog-content").is(':visible') && window.userdata['tura_aktywna']) {
		var adres = window.location.hash;
		if (adres == "#dokumenty" || adres == "#internet" || adres == "#skrzynka" || adres == "#internetBankowosc" || adres == "#finanse" || adres == "#statystyki" || adres == "#pracownicy" || adres == "#biuroGracza") {
			// ============== CHECK IF THERE ARE BLOCKED ACTIONS
			if ($("#dialog-info").dialog("isOpen") === true) {
				$("#dialog-info").dialog('close');
			}
			$.ajax({
				url: window.links.studentAjaxIsBlockedAction,
				global: false, // do not show cursor loading animation for this ajax request
				type: 'GET',
				success: function(result) {
					if (result > 0) {
						if (result == 2) // zaległe formularze
						{
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								$("#info-submit").val("Wypełnij dokumenty");
								activateInfo(parseInt(window.userdata["tura"]), 164); // zalegleFormularze z poprzednich lekcji
							});
						} else if (result == 7) // zalegle formularze po dotacji
						{
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								$("#info-submit").val("Wypełnij dokumenty");
								activateInfo(parseInt(window.userdata["tura"]), 176); // blokujemy gre bo brak biura
							});
						}
						/*
                                                else
                                                {
                                                        $("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
                                                        	submitInfo();
							});
                                                }
                                                */
					}
				}
			});
			//\============== CHECK IF THERE ARE BLOCKED ACTIONS
		}
	}
}

/***
 * Showing buttons one by one
 */
function setupButtons() {
	// left corner
	$("#button-ue").click(function() {
		if ($("#footer").is(":visible")) {
			$("#footer").hide("slide", {
				direction: "down"
			}, 1000, function() {
				$("#footer").css({
					"z-index": "4"
				});
			});
		} else {
			$("#footer").css({
				"z-index": "600"
			});
			$("#footer").show("slide", {
				direction: "down"
			}, 1000).delay(2000);
			$("#footer").mousemove(function() {
				$("#footer").hide("slide", {
					direction: "down"
				}, 1000, function() {
					$("#footer").css({
						"z-index": "4"
					});
				});
			});
		}
	});
	$("#button-ue").tipsy({
		gravity: 'sw',
		html: true
	});

	// right corner
	$("#button-about").click(function() {
		if ($("#dialog-about").find(".container").length <= 0) // check if form not loaded
		{
			$("#dialog-about").load(window.links.studentAjaxAboutDialog, function() {
				$("#dialog-about").dialog("open");
			});
		} else $("#dialog-about").dialog("open");
	});
	$("#button-about").tipsy({
		gravity: 'se',
		html: true,
		offset: 18
	});

	// button back from interior
	$("#button-back").click(function() {
		checkMissedForms();
		showMinimap();
	});

	$("#browser_close").click(function() {
		showMinimap();
		return false;
	});

	$("#headerbar img").click(function() {
		checkMissedForms();
		showMinimap();
	});

	if ($("#button-back").is(":visible"))
		$("#button-back").tipsy({
			gravity: 'w',
			trigger: 'manual',
			html: true
		}).tipsy('show');

	//$("#button-back").tipsy('show');

	// bottombar - left

	$("#symbol-komputer").clearQueue().finish().delay(0).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-komputer").click(function() {
		if (isInteriorAllowed('biuroGracza') && window.userdata['ilosc_biur'] > 0) // internet
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = 'biuroGracza';
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.'); // Akcja jest w tym momencie niedostępna.
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-finanse").clearQueue().finish().delay(200).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-finanse").click(function() {
		if (isInteriorAllowed('finanse'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "finanse";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-statystyki").clearQueue().finish().delay(400).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-statystyki").click(function() {
		if (isInteriorAllowed('statystyki'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "statystyki";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-pliki").clearQueue().finish().delay(600).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	/*	$("#symbol-pliki").click(function(){
			if (isInteriorAllowed('dokumenty'))
				if(!$(".ui-dialog-content").is(':visible'))
					window.location.hash="dokumenty";
				else
					$(".ui-dialog-title").effect("pulsate",{},700);
			else
				if(window.userdata['tura_aktywna'])
					showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
				else
					showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
		}); */
	$("#symbol-pliki").click(function() {
		if (isInteriorAllowed('dokumenty'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "dokumenty";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
			showMessage('Info', 'Ten przycisk nie jest aktywny.');
	});

	$("#symbol-pracownicy").clearQueue().finish().delay(800).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});
	$("#symbol-pracownicy").click(function() {
		if (isInteriorAllowed('pracownicy'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "pracownicy";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
		if (window.userdata['tura_aktywna'])
			showMessage('Info', 'Ten przycisk będzie aktywny na dalszym etapie gry.');
		else
			showMessage('Info', 'Ten przycisk będzie aktywny podczas trwania lekcji.');
	});

	$("#symbol-zlecenia").clearQueue().finish().delay(1000).fadeIn(500).addClass("hover1").delay(200).queue(function() {
		$(this).removeClass("hover1");
	});

	$('#tasks-counter').html(window.userdata.tasksToGo);
	if (!window.userdata.tura_aktywna && window.userdata.tasksToGo)
		$('#tasks-counter').fadeIn();
	else
		$('#tasks-counter').fadeOut();

	$("#symbol-zlecenia").click(function() {
		if (isInteriorAllowed('zlecenia'))
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = "zlecenia";
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		else
			showMessage('Info', 'Zlecenia mogą być rozwiązywane w domu, po zakończeniu lekcji.');
	});

	$(".barbutton").tipsy({
		gravity: 's'
	}); // show tooltips
	/************************/

	// bottombar - right
	$("#symbol-urzadpracy").clearQueue().finish().delay(2600).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-urzadpracy").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "26px",
				left: "147px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "40px",
				left: "142px"
			});
			p2.effect("pulsate", {}, 1000);
			window.game.map.buildings["urzadPracy"].highlight("#gameTooltip2");
			window.game.map.buildings["agencjaPosrednictwaPracy"].highlight("#gameTooltip3");
		}
	});

	$("#symbol-zus").clearQueue().finish().delay(2400).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-zus").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "55px",
				left: "60px"
			});
			p1.effect("pulsate", {}, 1000);
			window.game.map.buildings["zus"].highlight("#gameTooltip2");
		}
	});

	$("#symbol-urzadskarbowy").clearQueue().finish().delay(2200).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	}); // 1200
	$("#symbol-urzadskarbowy").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "40px",
				left: "110px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "14px",
				left: "150px"
			});
			p2.effect("pulsate", {}, 1000);
			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "55px",
				left: "120px"
			});
			p3.effect("pulsate", {}, 1000);
			window.game.map.buildings["urzadSkarbowy1"].highlight("#gameTooltip2");
			window.game.map.buildings["urzadSkarbowy2"].highlight("#gameTooltip3");
			window.game.map.buildings["urzadSkarbowy3"].highlight("#gameTooltip4");
		}
	});

	$("#symbol-bank").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-bank").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {

			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "22px",
				left: "139px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "50px",
				left: "50px"
			});
			p2.effect("pulsate", {}, 1000);
			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "40px",
				left: "120px"
			});
			p3.effect("pulsate", {}, 1000);
			var p4 = $("#mpointer4");
			p4.show();
			p4.css({
				top: "28px",
				left: "90px"
			});
			p4.effect("pulsate", {}, 1000);
			window.game.map.buildings["bank1"].highlight("#gameTooltip2");
			window.game.map.buildings["bank2"].highlight("#gameTooltip3");
			window.game.map.buildings["bank3"].highlight("#gameTooltip4");
			window.game.map.buildings["bank4"].highlight("#gameTooltip5");
		}
	});

	$('#rightbuttons [id!="symbol-biuro"]').click(function() {
		if ($("#symbol-biuro").hasClass("hover2")) window.game.map.clearBuildingFilters();
	}); //if clicked on button different than "symbol-biuro" - remove color filters from offices buildings
	$("#symbol-biuro").clearQueue().finish().delay(1800).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-biuro").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			window.game.map.clearBuildingFilters();
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");

			var p1 = $("#mpointer1");
			p1.show();
			//p1.css({top:"5px",left:"38px"});
			p1.css({
				top: "38px",
				left: "5px"
			});
			p1.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro27"].highlight("#gameTooltip2", true);
			var p2 = $("#mpointer2");
			p2.show();
			//p2.css({top:"14px",left:"32px"});
			p2.css({
				top: "32px",
				left: "14px"
			});
			p2.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro28b"].highlight("#gameTooltip3", true);
			var p3 = $("#mpointer3");
			p3.show();
			//p3.css({top:"30px",left:"33px"});
			p3.css({
				top: "33px",
				left: "30px"
			});
			p3.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro5"].highlight("#gameTooltip4", true);
			var p4 = $("#mpointer4");
			p4.show();
			//p4.css({top:"40px",left:"40px"});
			p4.css({
				top: "40px",
				left: "40px"
			});
			p4.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro18"].highlight("#gameTooltip5", true);
			var p5 = $("#mpointer5");
			p5.show();
			//p5.css({top:"16px",left:"56px"});
			p5.css({
				top: "56px",
				left: "16px"
			});
			p5.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro14"].highlight("#gameTooltip6", true);
			var p6 = $("#mpointer6");
			p6.show();
			//p6.css({top:"60px",left:"47px"});
			p6.css({
				top: "47px",
				left: "60px"
			});
			p6.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro13-2"].highlight("#gameTooltip7", true);
			var p7 = $("#mpointer7");
			p7.show();
			//p7.css({top:"19px",left:"69px"});
			p7.css({
				top: "69px",
				left: "19px"
			});
			p7.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro33"].highlight("#gameTooltip8", true);
			var p8 = $("#mpointer8");
			p8.show();
			//p8.css({top:"59px",left:"69px"});
			p8.css({
				top: "69px",
				left: "59px"
			});
			p8.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro28b-2"].highlight("#gameTooltip9", true);
			var p9 = $("#mpointer9");
			p9.show();
			//p9.css({top:"68px",left:"72px"});
			p9.css({
				top: "72px",
				left: "68px"
			});
			p9.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro29"].highlight("#gameTooltip10", true);
			var p10 = $("#mpointer10");
			p10.show();
			//p10.css({top:"79px",left:"59px"});
			p10.css({
				top: "59px",
				left: "79px"
			});
			p10.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro28-4"].highlight("#gameTooltip11", true);
			var p11 = $("#mpointer11");
			p11.show();
			//p11.css({top:"107px",left:"66px"});
			p11.css({
				top: "66px",
				left: "107px"
			});
			p11.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro43"].highlight("#gameTooltip12", true);
			var p12 = $("#mpointer12");
			p12.show();
			//p12.css({top:"65px",left:"41px"});
			p12.css({
				top: "41px",
				left: "65px"
			});
			p12.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro51"].highlight("#gameTooltip13", true);
			var p13 = $("#mpointer13");
			p13.show();
			//p13.css({top:"84px",left:"44px"});
			p13.css({
				top: "44px",
				left: "84px"
			});
			p13.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro1"].highlight("#gameTooltip14", true);
			var p14 = $("#mpointer14");
			p14.show();
			//p14.css({top:"91px",left:"54px"});
			p14.css({
				top: "54px",
				left: "91px"
			});
			p14.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro7"].highlight("#gameTooltip15", true);
			var p15 = $("#mpointer15");
			p15.show();
			//p15.css({top:"64px",left:"28px"});
			p15.css({
				top: "28px",
				left: "64px"
			});
			p15.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro10-2"].highlight("#gameTooltip16", true);
			var p16 = $("#mpointer16");
			p16.show();
			//p16.css({top:"82px",left:"31px"});
			p16.css({
				top: "31px",
				left: "82px"
			});
			p16.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro25"].highlight("#gameTooltip17", true);
			var p17 = $("#mpointer17");
			p17.show();
			//p17.css({top:"93px",left:"40px"});
			p17.css({
				top: "40px",
				left: "93px"
			});
			p17.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro48"].highlight("#gameTooltip18", true);
			var p18 = $("#mpointer18");
			p18.show();
			//p18.css({top:"129px",left:"57px"});
			p18.css({
				top: "57px",
				left: "129px"
			});
			p18.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro42-2"].highlight("#gameTooltip19", true);
			var p19 = $("#mpointer19");
			p19.show();
			//p19.css({top:"160px",left:"93px"});
			p19.css({
				top: "93px",
				left: "160px"
			});
			p19.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro59"].highlight("#gameTooltip20", true);
			var p20 = $("#mpointer20");
			p20.show();
			//p20.css({top:"79px",left:"24px"});
			p20.css({
				top: "24px",
				left: "79px"
			});
			p20.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro14-2"].highlight("#gameTooltip21", true);
			var p21 = $("#mpointer21");
			p21.show();
			//p21.css({top:"78px",left:"20px"});
			p21.css({
				top: "20px",
				left: "78px"
			});
			p21.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro16"].highlight("#gameTooltip22", true);

			var p22 = $("#mpointer22");
			p22.show();
			//p22.css({top:"94px",left:"1px"});
			p22.css({
				top: "1px",
				left: "94px"
			});
			p22.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro39"].highlight("#gameTooltip23", true);
			var p23 = $("#mpointer23");
			p23.show();
			//p23.css({top:"135px",left:"25px"});
			p23.css({
				top: "25px",
				left: "135px"
			});
			p23.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro4"].highlight("#gameTooltip24", true);
			var p24 = $("#mpointer24");
			p24.show();
			//p24.css({top:"160px",left:"21px"});
			p24.css({
				top: "21px",
				left: "160px"
			});
			p24.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro60"].highlight("#gameTooltip25", true);
			var p25 = $("#mpointer25");
			p25.show();
			//p25.css({top:"141px",left:"32px"});
			p25.css({
				top: "32px",
				left: "141px"
			});
			p25.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro54-2"].highlight("#gameTooltip26", true);
			var p26 = $("#mpointer26");
			p26.show();
			//p26.css({top:"140px",left:"37px"});
			p26.css({
				top: "37px",
				left: "140px"
			});
			p26.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro53-3"].highlight("#gameTooltip27", true);
			var p27 = $("#mpointer27");
			p27.show();
			//p27.css({top:"141px",left:"40px"});
			p27.css({
				top: "40px",
				left: "141px"
			});
			p27.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro50-4"].highlight("#gameTooltip28", true);
			var p28 = $("#mpointer28");
			p28.show();
			//p28.css({top:"155px",left:"48px"});
			p28.css({
				top: "48px",
				left: "155px"
			});
			p28.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro53"].highlight("#gameTooltip29", true);
			var p29 = $("#mpointer29");
			p29.show();
			//p29.css({top:"160px",left:"45px"});
			p29.css({
				top: "45px",
				left: "160px"
			});
			p29.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro52"].highlight("#gameTooltip30", true);
			var p30 = $("#mpointer30");
			p30.show();
			//p30.css({top:"169px",left:"40px"});
			p30.css({
				top: "40px",
				left: "169px"
			});
			p30.effect("pulsate", {}, 1000);
			window.game.map.buildings["biuro54"].highlight("#gameTooltip31", true);

			// additional

			var p31 = $("#mpointer31");
			p31.show();
			//p11.css({top:"52px",left:"40px"});
			p31.css({
				top: "40px",
				left: "52px"
			});
			p31.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro13"].highlight("#gameTooltip12");
			window.game.map.buildings["biuro13"].highlight("#gameTooltip32", true);
			var p32 = $("#mpointer32");
			p32.show();
			//p12.css({top:"72px",left:"54px"});
			p32.css({
				top: "54px",
				left: "72px"
			});
			p32.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro34"].highlight("#gameTooltip13");
			window.game.map.buildings["biuro34"].highlight("#gameTooltip33", true);


			var p34 = $("#mpointer34");
			p34.show();
			//p1.css({top:"8px",left:"28px"});
			p34.css({
				top: "28px",
				left: "8px"
			});
			p34.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro37"].highlight("#gameTooltip2");
			window.game.map.buildings["biuro37"].highlight("#gameTooltip35", true);
			var p35 = $("#mpointer35");
			p35.show();
			//p2.css({top:"13px",left:"43px"});
			p35.css({
				top: "43px",
				left: "13px"
			});
			p35.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro26"].highlight("#gameTooltip3");
			window.game.map.buildings["biuro26"].highlight("#gameTooltip36", true);
			var p36 = $("#mpointer36");
			p36.show();
			//p3.css({top:"12px",left:"64px"});
			p36.css({
				top: "64px",
				left: "12px"
			});
			p36.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro23"].highlight("#gameTooltip4");
			window.game.map.buildings["biuro23"].highlight("#gameTooltip37", true);
			var p37 = $("#mpointer37");
			p37.show();
			//p4.css({top:"22px",left:"58px"});
			p37.css({
				top: "58px",
				left: "22px"
			});
			p37.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro57"].highlight("#gameTooltip5");
			window.game.map.buildings["biuro57"].highlight("#gameTooltip38", true);
			var p38 = $("#mpointer38");
			p38.show();
			//p5.css({top:"31px",left:"64px"});
			p38.css({
				top: "64px",
				left: "31px"
			});
			p38.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro32"].highlight("#gameTooltip6");
			window.game.map.buildings["biuro32"].highlight("#gameTooltip39", true);
			var p39 = $("#mpointer39");
			p39.show();
			//p6.css({top:"35px",left:"75px"});
			p39.css({
				top: "75px",
				left: "35px"
			});
			p39.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro10"].highlight("#gameTooltip7");
			window.game.map.buildings["biuro10"].highlight("#gameTooltip40", true);
		}
	});
	$("#symbol-kontrahenci").clearQueue().finish().delay(1600).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-kontrahenci").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");

			// 5

			var p6 = $("#mpointer6");
			p6.show();
			//p13.css({top:"81px",left:"57px"});
			p6.css({
				top: "57px",
				left: "81px"
			});
			p6.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro42"].highlight("#gameTooltip14");
			window.game.map.buildings["biuro42"].highlight("#gameTooltip7");

			var p7 = $("#mpointer7");
			p7.show();
			//p7.css({top:"42px",left:"68px"});
			p7.css({
				top: "68px",
				left: "42px"
			});
			p7.effect("pulsate", {}, 1000);
			//window.game.map.buildings["metropolian"].highlight("#gameTooltip8");
			window.game.map.buildings["metropolian"].highlight("#gameTooltip8");
			var p8 = $("#mpointer8");
			p8.show();
			//p8.css({top:"52px",left:"66px"});
			p8.css({
				top: "66px",
				left: "52px"
			});
			p8.effect("pulsate", {}, 1000);
			//window.game.map.buildings["ing"].highlight("#gameTooltip9");
			window.game.map.buildings["ing"].highlight("#gameTooltip9");
			var p9 = $("#mpointer9");
			p9.show();
			//p9.css({top:"68px",left:"74px"});
			p9.css({
				top: "74px",
				left: "68px"
			});
			p9.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro28-2"].highlight("#gameTooltip10");
			window.game.map.buildings["biuro28-2"].highlight("#gameTooltip10");
			var p10 = $("#mpointer10");
			p10.show();
			//p10.css({top:"68px",left:"78px"});
			p10.css({
				top: "78px",
				left: "68px"
			});
			p10.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro29-2"].highlight("#gameTooltip11");
			window.game.map.buildings["biuro29-2"].highlight("#gameTooltip11");

			// 3

			var p14 = $("#mpointer14");
			p14.show();
			//p14.css({top:"112px",left:"64px"});
			p14.css({
				top: "64px",
				left: "112px"
			});
			p14.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro48-2"].highlight("#gameTooltip15");
			window.game.map.buildings["biuro48-2"].highlight("#gameTooltip15");
			var p15 = $("#mpointer15");
			p15.show();
			//p15.css({top:"70px",left:"42px"});
			p15.css({
				top: "42px",
				left: "70px"
			});
			p15.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro46"].highlight("#gameTooltip16");
			window.game.map.buildings["biuro46"].highlight("#gameTooltip16");
			var p16 = $("#mpointer16");
			p16.show();
			//p16.css({top:"87px",left:"42px"});
			p16.css({
				top: "42px",
				left: "87px"
			});
			p16.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro8"].highlight("#gameTooltip17");
			window.game.map.buildings["biuro8"].highlight("#gameTooltip17");
			var p17 = $("#mpointer17");
			p17.show();
			//p17.css({top:"102px",left:"58px"});
			p17.css({
				top: "58px",
				left: "102px"
			});
			p17.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro2"].highlight("#gameTooltip18");
			window.game.map.buildings["biuro2"].highlight("#gameTooltip18");
			var p18 = $("#mpointer18");
			p18.show();
			//p18.css({top:"112px",left:"52px"});
			p18.css({
				top: "52px",
				left: "112px"
			});
			p18.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro6"].highlight("#gameTooltip19");
			window.game.map.buildings["biuro6"].highlight("#gameTooltip19");
			var p19 = $("#mpointer19");
			p19.show();
			//p19.css({top:"132px",left:"53px"});
			p19.css({
				top: "53px",
				left: "132px"
			});
			p19.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro55"].highlight("#gameTooltip20");
			window.game.map.buildings["biuro55"].highlight("#gameTooltip20");
			var p20 = $("#mpointer20");
			p20.show();
			//p20.css({top:"72px",left:"26px"});
			p20.css({
				top: "26px",
				left: "72px"
			});
			p20.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro20-2"].highlight("#gameTooltip21");
			window.game.map.buildings["biuro20-2"].highlight("#gameTooltip21");
			var p21 = $("#mpointer21");
			p21.show();
			//p21.css({top:"101px",left:"33px"});
			p21.css({
				top: "33px",
				left: "101px"
			});
			p21.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro34-2"].highlight("#gameTooltip22");
			window.game.map.buildings["biuro34-2"].highlight("#gameTooltip22");
			var p22 = $("#mpointer22");
			p22.show();
			//p22.css({top:"103px",left:"3px"});
			p22.css({
				top: "3px",
				left: "103px"
			});
			p22.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro19"].highlight("#gameTooltip23");
			window.game.map.buildings["biuro19"].highlight("#gameTooltip23");
			var p23 = $("#mpointer23");
			p23.show();
			//p23.css({top:"103px",left:"3px"});
			p23.css({
				top: "4px",
				left: "104px"
			});
			p23.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro12-2"].highlight("#gameTooltip24");
			window.game.map.buildings["biuro12-2"].highlight("#gameTooltip24");
			var p24 = $("#mpointer24");
			p24.show();
			//p24.css({top:"127px",left:"31px"});
			p24.css({
				top: "31px",
				left: "127px"
			});
			p24.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro47"].highlight("#gameTooltip25");
			window.game.map.buildings["biuro47"].highlight("#gameTooltip25");
			var p25 = $("#mpointer25");
			p25.show();
			//p25.css({top:"135px",left:"43px"});
			p25.css({
				top: "43px",
				left: "135px"
			});
			p25.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro45"].highlight("#gameTooltip26");
			window.game.map.buildings["biuro45"].highlight("#gameTooltip26");
			var p26 = $("#mpointer26");
			p26.show();
			//p26.css({top:"145px",left:"38px"});
			p26.css({
				top: "38px",
				left: "145px"
			});
			p26.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro50-3"].highlight("#gameTooltip27");
			window.game.map.buildings["biuro50-3"].highlight("#gameTooltip27");
			var p27 = $("#mpointer27");
			p27.show();
			//p27.css({top:"139px",left:"34px"});
			p27.css({
				top: "34px",
				left: "139px"
			});
			p27.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro53-2"].highlight("#gameTooltip28");
			window.game.map.buildings["biuro53-2"].highlight("#gameTooltip28");
			var p28 = $("#mpointer28");
			p28.show();
			//p28.css({top:"165px",left:"24px"});
			p28.css({
				top: "24px",
				left: "165px"
			});
			p28.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro9"].highlight("#gameTooltip29");
			window.game.map.buildings["biuro9"].highlight("#gameTooltip29");
			var p29 = $("#mpointer29");
			p29.show();
			//p29.css({top:"177px",left:"33px"});
			p29.css({
				top: "33px",
				left: "177px"
			});
			p29.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuroPyramid"].highlight("#gameTooltip30");
			window.game.map.buildings["biuroPyramid"].highlight("#gameTooltip30");
			var p30 = $("#mpointer30");
			p30.show();
			//p30.css({top:"158px",left:"45px"});
			p30.css({
				top: "45px",
				left: "158px"
			});
			p30.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro50-2"].highlight("#gameTooltip31");
			window.game.map.buildings["biuro50-2"].highlight("#gameTooltip31");
			var p31 = $("#mpointer31");
			p31.show();
			//p31.css({top:"166px",left:"41px"});
			p31.css({
				top: "41px",
				left: "166px"
			});
			p31.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro50"].highlight("#gameTooltip32");
			window.game.map.buildings["biuro50"].highlight("#gameTooltip32");
			var p32 = $("#mpointer32");
			p32.show();
			//p32.css({top:"172px",left:"40px"});
			p32.css({
				top: "40px",
				left: "172px"
			});
			p32.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuro51-2"].highlight("#gameTooltip33");
			window.game.map.buildings["biuro51-2"].highlight("#gameTooltip33");
			var p33 = $("#mpointer33");
			p33.show();
			//p33.css({top:"213px",left:"54px"});
			p33.css({
				top: "54px",
				left: "213px"
			});
			p33.effect("pulsate", {}, 1000);
			//window.game.map.buildings["biuroElpro"].highlight("#gameTooltip34");
			window.game.map.buildings["biuroElpro"].highlight("#gameTooltip34");

		}
	});

	$("#symbol-szkolenia").clearQueue().finish().delay(1400).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	});
	$("#symbol-szkolenia").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "45px",
				left: "96px"
			});
			p1.effect("pulsate", {}, 1000);
			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "32px",
				left: "22px"
			});
			p2.effect("pulsate", {}, 1000);
			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "30px",
				left: "170px"
			});
			p3.effect("pulsate", {}, 1000);
			var p4 = $("#mpointer4");
			p4.show();
			p4.css({
				top: "80px",
				left: "162px"
			});
			p4.effect("pulsate", {}, 1000);

			window.game.map.buildings["centrumSzkoleniowe1"].highlight("#gameTooltip2");
			window.game.map.buildings["centrumSzkoleniowe2"].highlight("#gameTooltip3");
			window.game.map.buildings["centrumSzkoleniowe3"].highlight("#gameTooltip4");
			window.game.map.buildings["centrumSzkoleniowe4"].highlight("#gameTooltip5");
		}
	});
	$("#symbol-marketing").clearQueue().finish().delay(1200).fadeIn(500).addClass("hover2").delay(200).queue(function() {
		$(this).removeClass("hover2");
	}); // 2600
	$("#symbol-marketing").click(function() {
		$(".gameTooltip").each(function() {
			var tname = $(this).attr('aria-describedby');
			var child = $("#" + tname);
			if (child.length > 0) {
				$(this).tooltip('close');
				$(this).attr("title", "");
			}
			$(this).attr("canvasX", "-500");
			$(this).attr("canvasY", "-500");
			$(this).prop("canvasX", "-500");
			$(this).prop("canvasY", "-500");
			$(this).css({
				top: "-500px",
				left: "-500px"
			});
		});
		if ($(this).hasClass("hover2")) {
			$(this).removeClass("hover2");
			$(".minimap-pointer").hide();
		} else {
			$(".minimap-pointer").hide();
			$(".barbutton2").removeClass("hover2");
			$(this).addClass("hover2");
			var p1 = $("#mpointer1");
			p1.show();
			p1.css({
				top: "55px",
				left: "36px"
			});
			p1.effect("pulsate", {}, 1000);

			var p2 = $("#mpointer2");
			p2.show();
			p2.css({
				top: "25px",
				left: "32px"
			});
			p2.effect("pulsate", {}, 1000);

			var p3 = $("#mpointer3");
			p3.show();
			p3.css({
				top: "20px",
				left: "86px"
			});
			p3.effect("pulsate", {}, 1000);

			window.game.map.buildings["agencjaReklamowa1"].highlight("#gameTooltip2");
			window.game.map.buildings["agencjaReklamowa2"].highlight("#gameTooltip3");
			window.game.map.buildings["agencjaReklamowa3"].highlight("#gameTooltip4");
		}
	});

	$(".barbutton2").tipsy({
		gravity: 's'
	}); // show tooltips
	/************************/

	// hide minimap
	$("#symbol-hidemap").clearQueue().finish().delay(2800).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-hidemap").click(function(event) {
		if ($("#minimap").is(":visible")) {
			$("#minimap").fadeOut(1000, function() {
				checkSize();
			});
			$(this).clearQueue().finish().animate({
				"right": "10px"
			}, 1000, "easeInExpo");
			$("#bottombar").clearQueue().finish().animate({
				right: "-240px"
			}, 1000, "easeInExpo");
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "51px"
			}, 1000, "easeInExpo"); //80
			$("#symbol-hidemap-img").removeClass("hidemap");
			$("#symbol-hidemap-img").addClass("showmap");
		} else {
			$("#minimap").show();
			checkSize();
			$("#minimap").hide();
			$("#minimap").fadeIn(1000); //, function() { checkSize(); });
			//$("#minimap").show(); checkSize();
			$(this).clearQueue().finish().animate({
				"right": "250px"
			}, 1000, "easeOutExpo");
			$("#bottombar").clearQueue().finish().animate({
				right: "0px"
			}, 1000, "easeOutExpo");
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "321px"
			}, 1000, "easeOutExpo"); //350
			$("#symbol-hidemap-img").removeClass("showmap");
			$("#symbol-hidemap-img").addClass("hidemap");
		}
	});

	// sidebar buttons
	$("#symbol-firma").clearQueue().finish().delay(2000).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-punkty").clearQueue().finish().delay(2200).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-skrzynka").clearQueue().finish().delay(2400).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});
	$("#symbol-statbar").clearQueue().finish().delay(2600).fadeIn(500).addClass("hover3").delay(200).queue(function() {
		$(this).removeClass("hover3");
	});

	// show sidebar and switch buttons
	$("#symbol-firma").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "245px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "300px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "355px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "255px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "310px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "360px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().delay(500).fadeIn(500);
		$("#opis-punkty").clearQueue().finish().fadeOut(500);
		$("#opis-skrzynka").clearQueue().finish().fadeOut(500);
		$("#opis-stat").clearQueue().finish().fadeOut(500);
	});
	$("#symbol-punkty").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "45px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "300px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "355px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "55px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "310px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "360px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().fadeOut(500);
		$("#opis-punkty").clearQueue().finish().delay(500).fadeIn(500);
		$("#opis-skrzynka").clearQueue().finish().fadeOut(500);
		$("#opis-stat").clearQueue().finish().fadeOut(500);
	});
	$("#symbol-skrzynka").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "45px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "100px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "355px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "55px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "110px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "360px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().fadeOut(500);
		$("#opis-punkty").clearQueue().finish().fadeOut(500);
		$("#opis-skrzynka").clearQueue().finish().delay(500).fadeIn(500);
		$("#opis-stat").clearQueue().finish().fadeOut(500);
	});
	$("#symbol-statbar").click(function() {
		if ($("#sidebar-collapsed").is(":visible")) {
			setupSidebarData();
			$("#sidebar-collapsed").fadeOut(500, function() {
				$("#sidebar").css({
					width: "190px",
					height: "407px"
				});
				$(".sidebar-header").fadeIn(500);
				$("#sidebar-hide").animate({
					right: "0px"
				}, 500, "easeInExpo");
				$("#sidebar-expanded").fadeIn(1000).animate({
					right: "0px"
				}, 1000, "easeOutExpo");
			});
		}
		$("#symbol-firma").clearQueue().finish().animate({
			top: "-10px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-punkty").clearQueue().finish().animate({
			top: "45px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-skrzynka").clearQueue().finish().animate({
			top: "100px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#symbol-statbar").clearQueue().finish().animate({
			top: "155px",
			right: "150px"
		}, 500, "easeInCirc");
		$("#sidebar-firma").clearQueue().finish().animate({
			top: "0px"
		}, 500, "easeInCirc");
		$("#sidebar-punkty").clearQueue().finish().animate({
			top: "55px"
		}, 500, "easeInCirc");
		$("#sidebar-skrzynka").clearQueue().finish().animate({
			top: "110px"
		}, 500, "easeInCirc");
		$("#sidebar-statbar").clearQueue().finish().animate({
			top: "165px"
		}, 500, "easeInCirc");
		$("#opis-firma").clearQueue().finish().fadeOut(500);
		$("#opis-punkty").clearQueue().finish().fadeOut(500);
		$("#opis-skrzynka").clearQueue().finish().fadeOut(500);
		$("#opis-stat").clearQueue().finish().delay(500).fadeIn(500);
	});

	// hide sidebar
	$("#sidebar-hide").mouseover(function() {
		$(this).css("cursor", "pointer");
	});
	$("#sidebar-hide").click(function() {
		if (!$("#sidebar-collapsed").is(":visible")) {
			$("#sidebar-expanded").fadeOut(500, function() {
				$("#sidebar").css({
					width: "32px",
					height: "265px"
				});
				$(".sidebar-header").fadeOut(500);
				$("#sidebar-hide").animate({
					right: "-40px"
				}, 500, "easeOutExpo");
				$("#sidebar-collapsed").fadeIn(1000).animate({
					right: "-200px"
				}, 1000, "easeOutExpo");
				$("#symbol-firma").clearQueue().finish().animate({
					top: "50px",
					right: "10px"
				}, 500, "easeInCirc");
				$("#symbol-punkty").clearQueue().finish().animate({
					top: "105px",
					right: "10px"
				}, 500, "easeInCirc");
				$("#symbol-skrzynka").clearQueue().finish().animate({
					top: "160px",
					right: "10px"
				}, 500, "easeInCirc");
				$("#symbol-statbar").clearQueue().finish().animate({
					top: "215px",
					right: "10px"
				}, 500, "easeInCirc");
			});
		}
	});

	$(".barbutton3:not(#symbol-hidemap)").tipsy({
		gravity: 'e'
	}); // show tooltips
	$("#symbol-hidemap").tipsy({
		gravity: 'se'
	}); // show tooltips
}

window.updateSidebarRanking = function(newData) {
	if (newData != null) {
		//console.log('=== updateSidebarRanking');
		//console.log(newData);
		window.userdata['firmy_klasy'] = newData;
	}
	var firmy = "";
	var firmyKlasy = jQuery.parseJSON(window.userdata['firmy_klasy']);
	if (window.userdata['firmy_klasy'] != "") {
		for (i = 0; i < firmyKlasy.length; i++) {
			if (firmyKlasy[i]["nazwa"].length <= 1)
				firmy += '<span style="float:left;">firma bez nazwy</span> <span style="float:right;">' + Math.round(firmyKlasy[i]["punkty"]) + '</span><br/>';
			else
				firmy += '<span style="float:left;">' + firmyKlasy[i]["nazwa"] + '</span> <span style="float:right;">' + Math.round(firmyKlasy[i]["punkty"]) + '</span><br/>';
		}
	}
	$("#opis-stat").html(firmy);
}

window.updateSidebarPoints = function(newData) {
	if (newData != null) {
		//console.log('=== updateSidebarPoints');
		//console.log(newData);
		window.userdata['punkty_chemia'] = (!newData.punkty_chemia) ? "0" : newData.punkty_chemia;
		window.userdata['punkty_matematyka'] = (!newData.punkty_matematyka) ? "0" : newData.punkty_matematyka;
		window.userdata['punkty_biologia'] = (!newData.punkty_biologia) ? "0" : newData.punkty_biologia;
		window.userdata['punkty_fizyka'] = (!newData.punkty_fizyka) ? "0" : newData.punkty_fizyka;
		window.userdata['suma_punktow_firmy'] = (!newData.suma_punktow_firmy) ? "0" : newData.suma_punktow_firmy;
		window.userdata["stan_konta"] = (!newData.stan_konta) ? "0" : newData.stan_konta;
	}

	var tmpsum = parseInt(window.userdata['punkty_chemia']) + parseInt(window.userdata['punkty_matematyka']) + parseInt(window.userdata['punkty_biologia']) + parseInt(window.userdata['punkty_fizyka']);
	var tab1 = [parseInt(window.userdata['punkty_chemia']), parseInt(window.userdata['punkty_matematyka']), parseInt(window.userdata['punkty_biologia']), parseInt(window.userdata['punkty_fizyka'])];
	var max = Math.max.apply(Math, tab1);


	var stankonta = (!window.userdata["stan_konta"]) ? "0" : window.userdata["stan_konta"];
	$("#naglowek-tresc").html('<div id="money-icon"></div> <div id="money-number">' + parseFloat(stankonta).toFixed(2) + ' zł</div>'); //Punkty: "+window.userdata['suma_punktow_firmy']);
	$("#chempoints").html(window.userdata['punkty_chemia']);
	$("#matpoints").html(window.userdata['punkty_matematyka']);
	$("#biolpoints").html(window.userdata['punkty_biologia']);
	$("#fizpoints").html(window.userdata['punkty_fizyka']);

	//	var cheight = (parseInt(window.userdata['punkty_chemia'])/tmpsum)*150;
	//	var mheight = (parseInt(window.userdata['punkty_matematyka'])/tmpsum)*150;
	//	var bheight = (parseInt(window.userdata['punkty_biologia'])/tmpsum)*150;
	//	var fheight = (parseInt(window.userdata['punkty_fizyka'])/tmpsum)*150;

	var cheight = (window.userdata['punkty_chemia'] * 100) / max;
	var mheight = (window.userdata['punkty_matematyka'] * 100) / max;
	var bheight = (window.userdata['punkty_biologia'] * 100) / max;
	var fheight = (window.userdata['punkty_fizyka'] * 100) / max;

	//	$("#chart-chem").clearQueue().finish().animate({top:150-cheight,height:cheight},1000,"easeOutCirc");
	//	$("#chart-mat").clearQueue().finish().animate({top:150-mheight,height:mheight},1000,"easeOutCirc");
	//	$("#chart-biol").clearQueue().finish().animate({top:150-bheight,height:bheight},1000,"easeOutCirc");
	//	$("#chart-fiz").clearQueue().finish().animate({top:150-fheight,height:fheight},1000,"easeOutCirc");

	$("#chart-chem").clearQueue().finish().animate({
		height: cheight + '%'
	}, 1000, "easeOutCirc");
	$("#chart-mat").clearQueue().finish().animate({
		height: mheight + '%'
	}, 1000, "easeOutCirc");
	$("#chart-biol").clearQueue().finish().animate({
		height: bheight + '%'
	}, 1000, "easeOutCirc");
	$("#chart-fiz").clearQueue().finish().animate({
		height: fheight + '%'
	}, 1000, "easeOutCirc");

	$("#naglowek-stat").html("Punkty: " + Math.round(window.userdata['suma_punktow_firmy']));
}

/**
 * Print all data fetched from ajax into gui/sidebar etc.
 */
function setupSidebarData(global) // global - do not show loading animation if false
{
	var ref = typeof global !== 'undefined' ? global : true; // refresh

	function displayData() {
		var grupa = '<table style="width:100%">';

		$('#symbol-firma img').attr('src', window.userdata.logo_firmy);

		if (window.userdata['grupa'] != "") {
			var ludzie = jQuery.parseJSON(window.userdata['grupa']);
			for (var i in ludzie) {
				var user = ludzie[i];
				grupa += '<tr><td style="padding:0;text-align:right"><input data-user-id="' + user.id + '" ' + (window.userdata.tura_aktywna ? '' : 'disabled ') + 'class="studentPresent" type="checkbox" title="Obecny?" ' + (user.obecny ? 'checked' : '') + '/></td><td style="padding:0;text-align:center">' + user.imie + ' ' + user.nazwisko + '</td></tr>';
			}
		}

		grupa += "</table>";

		$("#icon-s-mat").tipsy();
		$("#icon-s-fiz").tipsy();
		$("#icon-s-biol").tipsy();
		$("#icon-s-chem").tipsy();

		var dziedzina = window.userdata['dziedzina_firmy'];
		if (dziedzina.length > 0) {
			if (dziedzina == "Matematyka") {
				$("#icon-s-mat").attr('id', 'icon-s-mat-active');
				$("#icon-s-mat-active").tipsy();
			} else if (dziedzina == "Fizyka") {
				$("#icon-s-fiz").attr('id', 'icon-s-fiz-active');
				$("#icon-s-fiz-active").tipsy();
			} else if (dziedzina == "Biologia") {
				$("#icon-s-biol").attr('id', 'icon-s-biol-active');
				$("#icon-s-biol-active").tipsy();
			} else if (dziedzina == "Chemia") {
				$("#icon-s-chem").attr('id', 'icon-s-chem-active');
				$("#icon-s-chem-active").tipsy();
			}
		}

		$("#naglowek-firma").html((window.userdata['nazwa_firmy'].length > 1) ? window.userdata['nazwa_firmy'] : "nienazwana firma");
		$("#opis-firma").html('zalogowany:<br/><span style="font-weight:bold;">' + window.userdata['imie'] + " " + window.userdata['nazwisko'] + "</span><br/><br/>" + 'klasa: <strong>' + window.userdata['klasa'] + '</strong>, szkoła:<br/><span style="font-weight:bold;">' + window.userdata['szkola'] + "</span><br/><br/>" + 'pozostali członkowie firmy:' + window.userdata["ile_czlonkow"] + '<br/>' + grupa);

		$('.studentPresent').tipsy({
			gravity: 'e'
		});
		$('.studentPresent').off('change');
		$('.studentPresent').on('change', function() {
			var _this = $(this);
			var present = _this.is(':checked') ? 1 : 0;
			var userId = _this.attr('data-user-id');
			$('.studentPresent').prop('disabled', true);
			$.ajax({
				type: 'POST',
				url: window.links.studentAjaxMarkStudentPresence,
				data: {
					studentId: userId,
					present: present
				},
				success: function(data) {
					if (data.error) {
						showMessage('Błąd', data.error);
						_this.prop('checked', !present);
					} else $('.studentPresent[data-user-id="' + userId + '"]')
						.prop('checked', data.present);
				},
				error: function() {
					_this.prop('checked', !present);
				},
				complete: function() {
					$('.studentPresent').prop('disabled', false);
				}
			});
		});

		updateSidebarPoints();

		Mailbox.update(window.userdata['naglowki_wiadomosci']);

		updateSidebarRanking();

		// ekran bankructwa
		if (window.userdata["stan_konta"] < 0) {
			bankrutDialogOpen();
		}
	}

	$.ajax({
		url: window.links.studentAjaxGetUserData,
		global: ref, // show loading animation?
		type: 'GET',
		success: function(result) {
			if (result != 0 && result != null) {
				var res = jQuery.parseJSON(result);

				// ===============================================
				// naprawia szybkie przejscie pomiedzy dwoma lekcjami (zanim dojdzie informacja o zakonczeniu poprzedniej)
				if (!ref &&
					(typeof window.userdata !== 'undefined') && (typeof res !== 'undefined') &&
					(typeof window.userdata['tura'] !== 'undefined') && (typeof res['tura'] !== 'undefined')) {
					if (res['tura'] != window.userdata['tura']) {
						if (res['tura_aktywna'] && !window.userdata['tura_aktywna']) {
							// if new lesson
							if ($("#dialog-info").dialog("isOpen") === true) {
								$("#dialog-info").dialog('close');
							}
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								activateInfo(parseInt(res["tura"]));
							});
						} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
							// if lesson time has passed, notify and disable some features
							if ($("#dialog-info").dialog("isOpen") === true) {
								$("#dialog-info").dialog('close');
							}
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								if (window.userdata.tura <= 4)
									activateInfo(-1);
								else
									activateInfo(0);
							});
						} else if (res['tura_aktywna'] && window.userdata['tura_aktywna']) {
							// if new lesson has started directly after previous one
							// showing welcome screen of next lesson - TEST IT
							if ($("#dialog-info").dialog("isOpen") === true) {
								$("#dialog-info").dialog('close');
							}
							$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
								activateInfo(parseInt(res["tura"]));
							});
						}
						getAllowedInteriors(); // update available actions for this lesson
					} else if (!res['tura_aktywna'] && window.userdata['tura_aktywna']) {
						// if lesson time has passed, notify and disable some features
						if ($("#dialog-info").dialog("isOpen") === true) {
							$("#dialog-info").dialog('close');
						}
						$("#dialog-info").load(window.links.studentAjaxInfoDialog, function() {
							if (window.userdata.tura <= 4)
								activateInfo(-1);
							else
								activateInfo(0);
						});
					}
				}
				// ===============================================

				window.userdata = res;
				displayData();
			}
		}
	});
}

/**
 * Machine text writer (letter by letter)
 */
$(function($) {
	$.fn.writeText = function(content, callback, charCallback) {
		if (!content) return;

		var contentArray = content.split(""),
			current = 0,
			elem = this;
		elem.html("");

		if (window.typewriter == undefined)
			window.typewriter = [];

		clearInterval(window.typewriter[$(this).attr('id')]);
		var objectId = $(this).attr('id');

		var timeInterval;
		if (window.DEBUG_MODE)
			timeInterval = 3;
		else
			timeInterval = 50;

		window.typewriter[$(this).attr('id')] = setInterval(function() {
			if (current < contentArray.length) {
				if (contentArray[current] == '<') {
					var tag = "";
					while (contentArray[current] != '>') {
						tag += contentArray[current++];
					}
					tag += contentArray[current++];
					elem.html(elem.html() + tag);
				} else {
					elem.html(elem.html() + contentArray[current++]);
				}
				if (charCallback != undefined)
					charCallback();
			} else {
				if (callback != undefined)
					callback();
				clearInterval(window.typewriter[objectId]);
			}
		}, 40); // timeInterval); // 50 //3 //5 //25 //50
	};
});

/**
 * Sets positions of sticked elements to canvas
 */
function adjustDialoguePosition() {
	if (window.game) {
		if (window.game.currentInterior != -1) {
			var interior = window.game.interiors[window.game.currentInterior];
			$(".sticker").each(function() {
				if (interior != undefined && $(this).position() != undefined && $(this).attr('canvasX') != undefined && $(this).attr('canvasY') != undefined) {
					var p = interior.bitmap.localToGlobal($(this).attr('canvasX'), $(this).attr('canvasY'));

					if ($(this).attr('canvasWidth') != undefined) {
						var p2 = interior.bitmap.localToGlobal(parseInt($(this).attr('canvasX')) + parseInt($(this).attr('canvasWidth')), 0);
						$(this).css({
							width: p2.x - p.x
						});
					}

					if ($(this).attr('canvasHeight') != undefined) {
						var p2 = interior.bitmap.localToGlobal(0, parseInt($(this).attr('canvasY')) + parseInt($(this).attr('canvasHeight')));
						$(this).css({
							height: p2.y - p.y
						});
					}

					$(this).css({
						left: p.x,
						top: p.y,
						position: 'absolute'
					});
				}
			});
		} else // city tooltips stickers
		{
			if (window.game.map) {
				var city = window.game.map.bitmap;
				$(".sticker").each(function() {
					if (city != undefined && $(this).position() != undefined && $(this).attr('canvasX') != undefined && $(this).attr('canvasY') != undefined) {
						var p = city.localToGlobal($(this).attr('canvasX'), $(this).attr('canvasY'));
						$(this).css({
							left: p.x,
							top: p.y,
							position: 'absolute'
						});
					}
				});
			}
		}
	}
}

$(window).resize(function() {
	adjustDialoguePosition();
}).mouseup(function() {
	adjustDialoguePosition();
}).mousedown(function() {
	adjustDialoguePosition();
}).mousemove(function() {
	adjustDialoguePosition();
});

//dialog potwierdzenia
function ask(title, message, callback, cbFalse, xclass) {
	var cancel = true;
	$((xclass ? '<div class="' + xclass + '">' : '<div>') + message + '</div>').dialog({
		title: title,
		modal: true,
		resizeable: false,
		draggable: false,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'Tak',
			click: function() {
				cancel = false;
				$(this).dialog('close');
				callback();
			}
		}, {
			text: 'Nie',
			click: function() {
				$(this).dialog('close');
			}
		}],
		close: function() {
			if (cancel && cbFalse)
				cbFalse();
			$(this).parent().remove();
		},
	});
}

function askEn(title, message, callback, cbFalse, xclass) {
	var cancel = true;
	$((xclass ? '<div class="' + xclass + '">' : '<div>') + message + '</div>').dialog({
		title: title,
		modal: true,
		resizeable: false,
		draggable: false,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'Yes',
			click: function() {
				cancel = false;
				$(this).dialog('close');
				callback();
			}
		}, {
			text: 'No',
			click: function() {
				$(this).dialog('close');
			}
		}],
		close: function() {
			if (cancel && cbFalse)
				cbFalse();
			$(this).parent().remove();
		},
	});
}

//okno dialogowe
function showMessage(title, message, options) {
	$('<div>' + message + '</div>').dialog({
		title: title,
		draggable: false,
		modal: true,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'OK',
			click: function() {
				$(this).dialog('close');
				if (options != null && options.ok != null)
					options.ok();
			}
		}],
		close: function() {
			$(this).parent().remove();
			if (options != null && options.close != null)
				options.close();
		},
	});
}

function showCustomMessage(title, message, options, width) {
	$('<div>' + message + '</div>').dialog({
		title: title,
		draggable: false,
		modal: true,
		dialogClass: 'przedsiebiorcaCommonDialog',
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		buttons: [{
			text: 'OK',
			click: function() {
				$(this).dialog('close');
				if (options != null && options.ok != null)
					options.ok();
			}
		}],
		close: function() {
			$(this).parent().remove();
			if (options != null && options.close != null)
				options.close();
		},
		width: width,
	});
}

function formatInterval(interval) {
	if (interval >= 60 * 60)
		interval = Math.round(interval / 60);
	var minutes = Math.floor(interval / 60);
	var mm = minutes < 10 ? '0' + minutes : minutes;
	var seconds = Math.floor(interval % 60);
	var ss = seconds < 10 ? '0' + seconds : seconds;
	return mm + ':' + ss;
}

// --- MAILBOX ---
Mailbox = {
	getMessage: function(id) {
		var messages = jQuery.parseJSON(window.userdata['naglowki_wiadomosci']);
		for (var i in messages)
			if (messages[i].id === id)
				return messages[i];
		return null;
	},
	update: function(data) {
		$("#naglowek-skrzynka").html("skrzynka odbiorcza");

		var skrzynka = '<div style="height:160px;overflow:hidden">';
		var skrzynkaNaglowki = jQuery.parseJSON(data);
		var notRead = 0;

		for (var i in skrzynkaNaglowki) {
			var msg = skrzynkaNaglowki[i];
			if (msg.przeczytana === '0') notRead++;
			skrzynka += '<div data-messageId="' + msg.id + '" class="mailboxMessage' + (msg.przeczytana === '0' ? ' toRead' : '') + '">' + msg.naglowek.substring(0, 22) + '...</div>';
		}

		$('#mailbox-counter').text(notRead);
		if (notRead)
			$('#mailbox-counter').fadeIn();
		else
			$('#mailbox-counter').fadeOut();
		skrzynka += '</div><div class="mailboxSeeAll">&lt; wszystkie wiadomości &gt;</div>';
		$("#opis-skrzynka").html(skrzynka);

		$('.mailboxMessage').off('click.SideBarMailbox');
		$('.mailboxMessage').on('click.SideBarMailbox', function() {
			if (!$(".ui-dialog-content").is(':visible')) {
				var messageId = $(this).attr('data-messageId');
				var message = Mailbox.getMessage(messageId);
				if (message === null) return;
				var currMsg = $('.mailboxMessagePreview[data-msgdlgid]');
				$('.mailboxMessagePreview').each(function() {
					if ($(this).hasClass('ui-dialog-content'))
						$(this).dialog('close');
				});
				if (currMsg.length > 0 && currMsg.attr('data-msgdlgid') === messageId)
					return;
				if ($(this).hasClass('toRead'))
					Mailbox.markAsRead(messageId);
				var dialog = $('<div data-msgdlgid="' + message.id + '" class="mailboxMessagePreview" title="Wiadomość">' +
					'	<div id="mainblock" style="width: 100%; clear: both; overflow: hidden;">' +
					'		<div class="barbutton2 hover2" style="cursor: default; background: url(\'' + window.links.baseUrl + '/images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
					'		<div class="row" style="text-align:center;padding-left:40px;padding-right:40px">' + message.naglowek + '</div>' +
					'		<div class="register-form-left" style="float: right;">' +
					'			<div class="row infodiv">' + message.tresc + '</div>' +
					'		</div>' +
					'	</div>' +
					'	<div class="row buttons" style="width: 100%; text-align: center;">' +
					'		<input type="button" value="OK" class="infodialog-button-ok ui-button ui-widget ui-state-default ui-corner-all" role="button" aria-disabled="false" style="display: inline-block;">' +
					'	</div>' +
					'</div>');
				dialog.find('.infodialog-button-ok').click(function() {
					dialog.dialog('close');
					$.ajax({
						url: window.links.studentAjaxGetUserData,
						global: false,
						type: 'GET',
						success: function(result) {
							if (result != 0 && result != null) {
								var res = jQuery.parseJSON(result);
								window.userdata = res;
								Mailbox.update(window.userdata['naglowki_wiadomosci']);
							}
						}
					});
				});
				dialog.dialog({
					autoOpen: true,
					hide: {
						effect: 'clip',
						duration: 500
					},
					show: {
						effect: 'scale',
						duration: 600
					},
					close: function() {
						$(this).remove();
					},
					position: {
						my: "center",
						at: "center",
						of: window
					},
					closeOnEscape: false,
					draggable: true,
					resizable: false,
					width: 500,
				});
			} else {
				$(".ui-dialog-title").effect("pulsate", {}, 700);
			}
		});

		$('.mailboxSeeAll').off('click.SideBarMailbox');
		$('.mailboxSeeAll').on('click.SideBarMailbox', function() {
			if (!$(".ui-dialog-content").is(':visible'))
				window.location.hash = 'skrzynka';
			else
				$(".ui-dialog-title").effect("pulsate", {}, 700);
		});
	},
	markAsRead: function(messageId) {
		$.ajax({
			type: 'POST',
			url: window.links.studentAjaxMessageMarkRead,
			global: false,
			data: {
				messageId: messageId
			},
			success: function(data) {
				if (data.error === undefined) {
					var counter = parseInt($('#mailbox-counter').text());
					counter--;
					if (counter < 0) counter = 0;
					if (counter === 0)
						$('#mailbox-counter').fadeOut();
					$('#mailbox-counter').text(counter);
					$('.toRead[data-messageId="' + messageId + '"]').removeClass('toRead');
					getAllowedInteriors();

					//$.get(window.links.studentAjaxGetChildAction, { "ostatnia_akcja" : data.idakcji , "tura" : window.userdata["tura"] }, function(re) {
					$.ajax({
						url: window.links.studentAjaxGetChildAction,
						global: false,
						type: 'GET',
						data: {
							"ostatnia_akcja": data.idakcji,
							"tura": window.userdata["tura"]
						},
						success: function(re) {
							if (re > 0) {
								//$.get(window.links.studentAjaxInfoSubmit, { "tura" : window.userdata["tura"], "akcja" : re, "przeczytana" : 0 }, function(ret) {});
								$.ajax({
									url: window.links.studentAjaxInfoSubmit,
									global: false,
									type: 'GET',
									data: {
										"tura": window.userdata["tura"],
										"akcja": re,
										"przeczytana": 0
									}
								});
							}
						}
					});
				}
			},
		});

	}
}

$(document).off('click.przedsiebiorcaHandlePayments');
$(document).on('click.przedsiebiorcaHandlePayments', '.payTax', function() {
	window.oplaty = new Array();
	window.oplaty.kontrahentId = $(this).attr('data-kontrahentid');
	window.oplaty.idFirmy = $(this).attr('data-idfirmy');
	window.oplaty.rodzajOplaty = $(this).attr('data-rodzajoplaty');
	window.oplaty.title = $(this).attr('data-title');
	window.oplaty.wartosc = $(this).attr('data-wartosc');
	window.oplaty.updated = true;

	if (window.location.hash == '#internetBankowosc') {
		var delay = (function() {
			var timer = 0;
			return function(callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
			};
		})();
		window.location.hash = 'internet';
		delay(function() {
			window.location.hash = 'internetBankowosc';
		}, 1000);
	} else
		window.location.hash = 'internetBankowosc';

	return false;
});
$(document).on('click.przedsiebiorcaHandlePayments', '.payVat', function() {
	window.oplaty = new Array();
	window.oplaty.kontrahentId = $(this).attr('data-kontrahentid');
	window.oplaty.idFirmy = $(this).attr('data-idfirmy');
	window.oplaty.rodzajOplaty = $(this).attr('data-rodzajoplaty');
	window.oplaty.title = $(this).attr('data-title');
	window.oplaty.wartosc = $(this).attr('data-wartosc');
	window.oplaty.updated = true;

	if (window.location.hash == '#internetBankowosc') {
		var delay = (function() {
			var timer = 0;
			return function(callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
			};
		})();
		window.location.hash = 'internet';
		delay(function() {
			window.location.hash = 'internetBankowosc';
		}, 1000);
	} else
		window.location.hash = 'internetBankowosc';

	return false;
});
$(document).on('click.przedsiebiorcaHandlePayments', '.payOffice', function() {
	window.oplaty = new Array();
	window.oplaty.kontrahentId = $(this).attr('data-kontrahentid');
	window.oplaty.idFirmy = $(this).attr('data-idfirmy');
	window.oplaty.rodzajOplaty = $(this).attr('data-rodzajoplaty');
	window.oplaty.title = $(this).attr('data-title');
	window.oplaty.wartosc = $(this).attr('data-wartosc');
	window.oplaty.updated = true;

	if (window.location.hash == '#internetBankowosc') {
		var delay = (function() {
			var timer = 0;
			return function(callback, ms) {
				clearTimeout(timer);
				timer = setTimeout(callback, ms);
			};
		})();
		window.location.hash = 'internet';
		delay(function() {
			window.location.hash = 'internetBankowosc';
		}, 1000);
	} else
		window.location.hash = 'internetBankowosc';


	return false;
});


$(document).off('click.przedsiebiorcaHandleTendersMail');
$(document).on('click.przedsiebiorcaHandleTendersMail', '.gotoTender[data-kontrahentid]', function() {

	function getKontrahentBuildingId(kontrahentId) {
		var kontrahenci = jQuery.parseJSON(window.userdata['kontrahenci']);
		for (var i in kontrahenci) {
			var kontrahent = kontrahenci[i];
			if (kontrahent.id == kontrahentId)
				return i;
		}
		return null;
	}

	var kontrahentId = $(this).attr('data-kontrahentid');

	var buildingId = getKontrahentBuildingId(kontrahentId);

	var building = window.game.map.getBuildingById(buildingId);

	if (building) {
		Building.current = building;
		window.location.hash = 'biuroZlecenia1';
	}

	return false;
});

$(document).on('click.przedsiebiorcaHandleTendersMail', 'a[accept][invitationid]', function() {

	var accept = $(this).attr('accept');
	var invId = $(this).attr('invitationid');

	$('<div><table style="width:100%;height:90%;background:rgba(255,255,255,0.4)">' + '<tr><td class="msg" style="text-align:center">Proszę czekać...</td></tr></table></div>').dialog({
		title: 'Wysyłanie żądania',
		modal: true,
		autoOpen: true,
		closeOnEscape: false,
		hide: {
			effect: 'clip',
			duration: 500
		},
		show: {
			effect: 'scale',
			duration: 600
		},
		open: function() {
			var _dlg = $(this);
			$.ajax({
				type: 'POST',
				url: window.links.studentAjaxAcceptOrderInvitation,
				data: {
					accept: accept,
					invitationId: invId
				},
				success: function(data) {
					if (data.error)
						_dlg.find('.msg').html(data.error);
					else
						_dlg.dialog('close');
				},
			});
		},
		close: function() {
			$(this).parent().remove();
		},
		position: {
			my: 'center',
			at: 'center',
			of: window
		},
		buttons: [{
			text: 'OK',
			click: function() {
				$(this).dialog('close');
			}
		}],
		draggable: true,
		resizable: false,
		width: 400,
		height: 400
	});

	return false;
});

$(document).on('click.przedsiebiorcaHandleTendersMail', 'a.bonusTasksLink', function() {
	var lang = $(this).attr('data-lang');

	if (window.location.hash.length && window.location.hash != 'city')
		window.location.hash = 'city';

	$(this).parents('.mailboxMessagePreview').dialog('close');

	function enableBts(en) {

	}

	tasksDialogOpen({
		endpointParams: {
			lang: lang
		},
		endpoint: window.links.studentAjaxFetchBonusTasks,
		maxTasks: 0,
		tasks: 0,
		actions: ['Select'],
		vat: 0.23,
		title: 'Bonusowe zlecenia',
		enable: enableBts
	});

	return false;
});


function tasksDialogOpen(options) {
	// if (window.tasksDialog) {
	console.log(options);
	if (parseInt(options.endpointParams.lang) == 1)
		window.tasksDialogEn(options);
	else
		window.tasksDialog(options);
	// } else {
	// 	yepnope([{
	// 		load: window.links.baseUrl + '/js/gui/gui-taskslist.js',
	// 		complete: function() {
	// 			window.tasksDialog(options);
	// 		}
	// 	}]);
	// }
}

function bankrutDialogOpen(force) {
	// if (window.activateBankrut) {
		if (force) {
			window.BankrutDlgLastFired = 0;
			window.BankrutDlgOpened = 0;
		}
		window.activateBankrut(force);
	// } else
	// 	yepnope([{
	// 		load: window.links.studentModuleBankrut,
	// 		complete: function() {
	// 			window.BankrutDlgLastFired = 0;
	// 			window.BankrutDlgOpened = 0;
	// 			window.activateBankrut(force);
	// 		}
	// 	}]);
}

function showMinimap() {

	if (!$(".ui-dialog-content").is(':visible')) {
		if ($("#minimap").not(":visible")) {
			$("#minimap").show();
			checkSize();
			$("#minimap").hide();
			$("#minimap").fadeIn(1000); //, function() { checkSize(); });
			$("#symbol-hidemap").clearQueue().finish().animate({
				"right": "250px"
			}, 1000, "easeOutExpo");
			$("#bottombar").clearQueue().finish().animate({
				right: "0px"
			}, 1000, "easeOutExpo");
			$("#rightbuttons").clearQueue().finish().animate({
				marginRight: "321px"
			}, 1000, "easeOutExpo"); //350
			$("#symbol-hidemap-img").removeClass("showmap");
			$("#symbol-hidemap-img").addClass("hidemap");

		}

		if ($("#rightbuttons").not(":visible"))
			$("#rightbuttons").fadeIn(500, function() {
				if (($("#minimap").is(":visible") && (window.innerWidth < 1216)) || ($("#minimap").not(":visible") && (window.innerWidth < 945))) // 1162  891
					$("#buttons").clearQueue().finish().animate({
					height: "110px"
				}, 500, "easeOutExpo");
			});

		$("#button-back").hide();
		//$(".tipsy-inner").tipsy().hide();

		window.location.hash = "city";
	} else {
		$(".ui-dialog-title").effect("pulsate", {}, 700);
	}
	return this;
}

function browser_close() {
	if (window.userdata['ilosc_biur'] == 0) {
		showMinimap();
	} else {
		window.location.hash = '#biuroGracza';
	}
}
